

varying vec4 color;
varying float NdotL;
flat varying vec4 labvalue;

varying vec4 lmtexcoord;
varying vec3 viewVector;
varying vec3 normal1;

varying float mat;

flat varying vec3 ambientUp;
flat varying vec3 ambientDown;
flat varying vec3 ambientLeft;
flat varying vec3 ambientRight;
flat varying vec3 ambientB;
flat varying vec3 ambientF;
flat varying float ambientA;
flat varying vec4 sunColor;

#include "/lib/light.glsl"

#define diagonal3(m) vec3((m)[0].x, (m)[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

float computePhaseFactor(float x, float g)
{
    float gg = g * g;
    return (gg * -0.25 + 0.25) * pow(-2.0 * (g * x) + (gg + 1.0), -1.5) / PI;
}

/* RENDERTARGETS: 10 */
void main()
{

    vec3 fragpos = toScreenSpaceDH(gl_FragCoord.xyz * vec3(texelSize, 1.0));
    vec3 p3 = toWorldSpace(fragpos);

    if (clamp(1.0 - length(p3.xyz) / clamp(far - 32.0, 32.0, far), 0.0, 1.0) > 0.0)
    {
        discard;
        return;
    }
    float angleFactor = dot(normalize(p3), lightPos);

    float phase0 = computePhaseFactor(angleFactor, 0.4);

    vec4 color = color;

    float diffuseSun = max(dot(normal1, lightPos), 0.0);
    diffuseSun *= clamp((pow(lmtexcoord.w, 16) * 2 - 0.5) * 2, 0, 1);

    vec3 ambient = calcAmbientLight(normal1, lmtexcoord.zw, ambientUp, ambientDown, ambientRight, ambientLeft, ambientB, ambientF, vec3(0.1), diffuseSun, vec3(0.0));

    vec4 colorOut = color;
    colorOut.rgb = 1 * toLinear(colorOut.rgb);
    colorOut.rgb = (colorOut.rgb) * ambient;

    gl_FragData[0] = vec4(colorOut);
}
